/*
 This program demonstrates the problems 
 caused by using macros with arguments
 that have side effects.
 
 Y = 2, z = 3
 
 (2 > 3) //after y = 3 and z = 4
 False
 
 z++ which goes to 5
 
 But x is assigned the value before the increment, therefore x = 4
 
 */
#include <stdio.h>

#define MAX(a,b) ((a)>(b) ? (a) : (b))

int main()
{
   int x;
   int y = 2;
   int z = 3;

   x = MAX(y++, z++);

   printf("x=%d, y=%d, z=%d\n", x, y, z);

   return 0;
}
